<?php


namespace FilterEverything\Filter\Pro\Entities;

if ( ! defined('ABSPATH') ) {
    exit;
}

use FilterEverything\Filter\PostMetaNumEntity;

class PostMetaExistsEntity extends PostMetaNumEntity
{

    public function __construct( $postMetaName, $postType ){
        /**
         * @feature clean code from unused methods
         */
        $this->entityName = $postMetaName;
        $this->setPostTypes( array($postType) );
    }

    public function selectTerms($alreadyFilteredPosts = [] ){
        $return = [];
        $i = 1;

        foreach ( array('yes', 'no') as $slug ){
            $termObject = new \stdClass();
            $termObject->slug = $slug;
            $termObject->name = apply_filters( 'wpc_filter_post_meta_exists_term_name', $slug,  $this->getName() );
            $termObject->term_id = $this->getTermId($slug);
            $termObject->posts = [];
            $termObject->count = 0;
            $termObject->cross_count = 0;
            $termObject->post_types = [];
            $termObject->wp_queried  = false;

            $return[ $slug ] = $termObject;

            $i++;
        }

        return $return;
    }

    function excludeTerms( $terms )
    {
        $exclude = [];

        if( ! empty( $this->excludedTerms ) ){
            $exclude = $this->excludedTerms;
        }

        $exclude_flipped = array_flip( $exclude );

        if( $this->isInclude ){
            $included_terms = [];
            foreach( $terms as $index => $term ){
                if( isset( $exclude_flipped[$term->slug] ) ){
                    $included_terms[$index] = $term;
                }
            }
            $terms = $included_terms;
        }else{
            foreach( $terms as $index => $term ){
                if(  isset( $exclude_flipped[$term->slug] ) ){
                    unset( $terms[$index] );
                }
            }
        }

        return $terms;
    }

    function populateTermsWithPostIds( $setId, $post_type )
    {
        foreach( $this->items as $slug => $term ){
            $term_posts = $this->getTermPosts( $term->slug, $setId );
            $this->items[$slug]->posts = $term_posts['posts'];
            $this->items[$slug]->post_types = $term_posts['post_types'];
            if ($this->entityName == '_sale_price' && flrt_is_woo_discount_rules()){
                if(!empty($this->wdr_product_ids)){
                    $this->items['yes']->posts = array_unique(array_merge($this->items['yes']->posts, $this->wdr_product_ids));
                    $this->items['no']->posts = array_diff($this->items['no']->posts, $this->wdr_product_ids);
                }
            }
        }
    }

    public function getTerm( $termId ){
        if( ! $termId ){
            return false;
        }

        if( in_array( $termId, array( 'yes', 'no' ) ) ){
            $termId = $this->getTermId( $termId );
        }

        foreach ( $this->getTerms() as $term ){
            if( $termId == $term->term_id ){
                return $term;
            }
        }

        return false;
    }

    private function getTermPosts( $slug, $setId )
    {   global $wpdb;

        $postIds    = [];
        $postTypes  = [];
        $IN         = false;

        $e_name   = wp_unslash( $this->entityName );

        $key = $this->getName().'_'.$slug;
        $transient_key = flrt_get_post_ids_transient_key( $key );

        if ( false === ( $result = flrt_get_transient( $transient_key ) ) ) {

            /**
             * In case of empty '_sale_price' meta values
             * @todo should be implemented via do_action hook
             */
            if ( $e_name === '_sale_price' ) {
                $del_empty_sql  = "DELETE FROM {$wpdb->postmeta} WHERE {$wpdb->postmeta}.meta_key = '%s'";
                $del_empty_sql .= "AND {$wpdb->postmeta}.meta_value = ''";
                $del_empty_sql  = $wpdb->prepare( $del_empty_sql, '_sale_price' );

                $wpdb->query( $del_empty_sql );
            }

            /**
             * End of empty '_sale_price' meta values
             */

            if (!empty($this->postTypes)) {
                foreach ($this->postTypes as $postType) {
                    $pieces[] = $wpdb->prepare("%s", $postType);
                }

                $IN = implode(", ", $pieces);
            }

            $compare = ($slug === 'yes') ? "> 0" : "IS NULL";

            $sql[] = "SELECT DISTINCT {$wpdb->posts}.ID,{$wpdb->posts}.post_type";
            $sql[] = "FROM {$wpdb->posts}";
            $sql[] = "LEFT JOIN {$wpdb->postmeta}";
            $sql[] = "ON ( {$wpdb->postmeta}.post_id = {$wpdb->posts}.ID AND {$wpdb->postmeta}.meta_key = '%s' )";
            $sql[] = "WHERE 1=1";
            $sql[] = "AND ( {$wpdb->postmeta}.post_id {$compare} )";

            if ($IN) {
                $sql[] = "AND {$wpdb->posts}.post_type IN( {$IN} )";
            }

            $sql = implode(' ', $sql);
            $sql = $wpdb->prepare($sql, $e_name);

            /**
             * Filters terms SQL-query and allows to modify it
             */
            $sql    = apply_filters( 'wpc_filter_get_post_meta_exists_terms_sql', $sql, $e_name );

            $result = $wpdb->get_results($sql, ARRAY_A);

            flrt_set_transient( $transient_key, $result, FLRT_TRANSIENT_PERIOD_HOURS * HOUR_IN_SECONDS );
        }

        if(flrt_is_woo_discount_rules() && $this->entityName === '_sale_price')
            $wdr_woo_discount_rules = $this->getWooDiscountRulesClass();

        if( ! empty( $result ) ){
            foreach( $result as $post){
                $postIds[] = $post['ID'];
                $postTypes[$post['ID']] = $post['post_type'];

                if (flrt_is_woo_discount_rules()) {
                    if ($this->entityName === '_sale_price') {
                        $product = wc_get_product($post['ID']);
                        if ($product) {
                            $wdr_product_has_sale = $wdr_woo_discount_rules->getProductPriceToDisplay($product);
                            if ($wdr_product_has_sale) {
                                $this->wdr_product_ids[] = $post['ID'];
                            }
                        }
                    }
                }
            }
        }

        return array( 'posts' => $postIds, 'post_types' => $postTypes);

    }

    /**
     * @return object WP_Query
     */
    public function addTermsToWpQuery( $queried_value, $wp_query )
    {
        $meta_query = [];
        $compare    = false;
        $meta_key   = $queried_value['e_name'];
        $existsCount = 0;

        // Add existing Meta Query if present
        $this->importExistingMetaQuery($wp_query);

        if ((flrt_is_woocommerce() && flrt_is_woo_discount_rules() && $meta_key == '_sale_price')) {
            $query_post_in = $this->wdrAddProductsToFilterQuery($wp_query, $queried_value['values']);
            $wp_query->set('post__in', $query_post_in);
        } else {
            foreach ($queried_value['values'] as $value) {
                if ($value === 'yes') {
                    $compare = 'EXISTS';
                } else if ($value === 'no') {
                    $compare = 'NOT EXISTS';
                }

                $meta_query = array(
                    'key' => $meta_key
                );

                if ($compare) {
                    $meta_query['compare'] = $compare;
                }

                if (count($queried_value['values']) > 1) {
                    $this->addMetaQueryArray($meta_query, 'OR');
                } else {
                    $this->addMetaQueryArray($meta_query);
                }
            }
        }

        if (count($this->new_meta_query) > 1) {
            $this->new_meta_query['relation'] = 'AND';
        }
        /**
         * This should be done via hook
         */

        $wp_query->set('meta_query', $this->new_meta_query);
        $this->new_meta_query = [];

        return $wp_query;
    }


    /*
     * Check products what have sale if
     * WooCommerce Discounts Rules
    */
    public function wdrAddProductsToFilterQuery($wp_query, $queried_value)
    {
        $post__in = [];
        $post__not_in = [];
        $wdr_woo_discount_rules = $this->getWooDiscountRulesClass();

        $args = array(
            'status'    => 'publish',
            'limit'     => -1,
            'return'    => 'ids'
        );

        //Added for work woo_discount_rules and query hash
        $args['flrt_wdr_pagination'] = true;

        if (isset($wp_query->queried_object->taxonomy) && isset($wp_query->queried_object->taxonomy)) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => $wp_query->queried_object->taxonomy,
                    'field'    => 'term_id',
                    'terms'    => array($wp_query->queried_object->term_id),
                )
            );
        }

        $products = wc_get_products($args);

        foreach ($products as $post_id) {
            $woo_sale_price = get_post_meta($post_id, '_sale_price', true);
            if ($wdr_woo_discount_rules->getProductPriceToDisplay($post_id) || !empty($woo_sale_price)) {
                $post__in[] = $post_id;
            } else {
                $post__not_in[] = $post_id;
            }
        }
        $query_post_in = [];
        foreach ($queried_value as $value) {
            if ($value === 'yes') {
                $query_post_in = array_merge($query_post_in, $post__in);
            } else if ($value === 'no') {
                $query_post_in = array_merge($query_post_in, $post__not_in);
            }
        }
        if(isset($wp_query->query_vars['post__in']) && !empty($wp_query->query_vars['post__in'])){
            $query_post_in = array_intersect($query_post_in, $wp_query->query_vars['post__in']);
        }
        if(empty($query_post_in)){
            return [0];
        }
        return $query_post_in;
    }
}